/*+ TsipWindow.h
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2005 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file defines the CTsipWindow class.
 *            
 * Revision History:
 *    05-18-2005    Mike Priven
 *                  Written
 *
 * Notes:
 *
-*/

#ifndef TSIP_WINDOW_H
#define TSIP_WINDOW_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


/*---------------------------------------------------------------------------*\
 |                      C L A S S   D E F I N I T I O N
\*---------------------------------------------------------------------------*/
class CTsipWindow : public CDialog
{

public: //==== P U B L I C   M E T H O D S ===================================/

    CTsipWindow(CWnd* pParent = NULL);   // standard constructor

    void ConfigureDataLog (BOOL);
    void ProcessPkt       (CString &str, unsigned char ucPkt[], int nPktLen);


public: //==== P U B L I C   M E M B E R   V A R I A B L E S =================/

    //{{AFX_DATA(CTsipWindow)
    enum { IDD = IDD_TSIP_WINDOW };
    CRichEditCtrl   m_edtOutput;
    //}}AFX_DATA

    CMetaParser m_MetaParser;
    CCommPort   m_SerialPort;
    CUIntArray  m_Ports;
    int         m_nState;

    class CDataLog
    {
        public:
            CString strAsciiFile, strRawFile;
            BOOL    bLogAscii, bLogRaw, bLog;
            CFile   *pAsciiFile, *pRawFile;
    };

    CDataLog m_tLog;


protected: //==== P R O T E C T E D   M E T H O D S ==========================/

    //{{AFX_VIRTUAL(CTsipWindow)
    virtual void DoDataExchange(CDataExchange* pDX);
    virtual void OnCancel();
    //}}AFX_VIRTUAL

    //{{AFX_MSG(CTsipWindow)
    virtual BOOL OnInitDialog();
    afx_msg void OnCom();
    afx_msg void OnLog();
    afx_msg void OnClear();
    afx_msg void OnStart();
    afx_msg void OnClose();
    afx_msg void OnSize(UINT nType, int cx, int cy);
    //}}AFX_MSG

    DECLARE_MESSAGE_MAP()


private: //==== P R I V A T E   M E T H O D S ================================/

    bool InitMonitor     ();
    void Writeln         (CString str);
    void ArrangeControls (int nWndWidth, int nWndHeight);


private: //==== P R I V A T E   M E M B E R   V A R I A B L E S ==============/

    HANDLE m_hMonitor;
    bool   m_bInit, m_bFirstLine, m_bPaused, m_bLargeSystemFonts;

public:
	afx_msg void OnBnClickedSendNmeaPacket();
};

#endif
